#include "GetPoint.js"

function GetLine( pointarray, firstpromptid, secondpromptid )
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();

	var linefactory = moi.command.createFactory( 'line' );

	pointpicker.bindResultPt( linefactory.getInput(0) );

	if ( !GetPoint( pointpicker ) )
		return false;

	ui.beginUIUpdate();
	ui.hideUI( firstpromptid == undefined ? 'FirstLinePrompt' : firstpromptid );
	ui.showUI( secondpromptid == undefined ? 'SecondLinePrompt' : secondpromptid );
	ui.endUIUpdate();
		
	pointarray[0] = pointpicker.pt;

	pointpicker.clearBindings();
	pointpicker.bindResultPt( linefactory.getInput(1) );
	
	if ( !GetPoint( pointpicker ) )
		return false;
		
	pointarray[1] = pointpicker.pt;
	
	linefactory.cancel();
	
	return true;
}
